//=============================================================================
// WeaponPhotonPistol.
//=============================================================================
class WeaponPhotonPistol extends PhotonWeapon;

//
// functions to change ammo types
//
function bool LoadAmmo(int ammoNum)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if ((ammoNum < 0) || (ammoNum > 2))
		return False;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	newAmmoClass = AmmoNames[ammoNum];

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmoClass.Default.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

				// otherwise, set us to fire projectiles
				bInstantHit = False;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				FireSound = Default.FireSound;		// handled by the projectile
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;

				if ( AmmoRedPhoton(newAmmo) != None )
                                	{
                                        ReloadCount = 8;
                                        }
				if ( AmmoBluePhoton(newAmmo) != None )
                                        {
                                        ReloadCount = Default.ReloadCount;
                                        }
                                }
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmoClass.Default.ItemName));
			return True;
		}
		else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}
	return False;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
      PickupAmmoCount = mpReloadCount;
	}
}

//simulated function SwapMuzzleFlashTexture()
//{
//   	if ( !bHasMuzzleFlash )
//      		return;  
//
//	MultiSkins[2] = Texture'LaserSpot2';
//	SetTimer(0.2, False);
//}

defaultproperties
{
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_All
     ShotTime=0.350000
     reloadTime=1.250000
     HitDamage=20
     maxRange=5000
     AccurateRange=2500
     BaseAccuracy=0.550000
     bCanHaveScope=True
     ScopeFOV=15
     bCanHaveLaser=True
     bHasLaser=True
     AmmoNames(0)=Class'Markistan.AmmoBluePhoton'
     AmmoNames(1)=Class'Markistan.AmmoRedPhoton'
     ProjectileNames(0)=Class'Markistan.BluePhotonBlast'
     ProjectileNames(1)=Class'Markistan.RedPhotonBlast'
     mpReloadTime=0.500000
     mpHitDamage=30
     mpBaseAccuracy=0.100000
     mpAccurateRange=2000
     mpMaxRange=2000
     mpReloadCount=10
     mpPickupAmmoCount=30
     AmmoName=Class'Markistan.AmmoBluePhoton'
     PickupAmmoCount=30
     FireOffset=(X=-25.000000,Y=8.000000,Z=14.000000)
     ProjectileClass=Class'Markistan.BluePhotonBlast'
     shakemag=30.000000
     FireSound=Sound'Markistan.Weapons.PhotonPistolFire'
     AltFireSound=Sound'Markistan.Weapons.PistolCock'
     CockingSound=Sound'Markistan.Weapons.PistolReload'
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     InventoryGroup=173
     ItemName="|p7Z-13 Photon Pistol"
     PlayerViewOffset=(X=22.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Glock'
     PickupViewMesh=LodMesh'DeusExItems.GlockPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Glock3rd'
     Icon=Texture'Markistan.Icons.BeltIconZ13'
     largeIcon=Texture'Markistan.Icons.InventoryIconZ13'
     largeIconWidth=96
     largeIconHeight=48
     Description="The Z-13 is yet another marvelous technological wonder created by markistan. It discharges high amounts of energy in small spheres that burn the air as they travel and as they may not be able to blow through doors, their effects are devestating to any organic or electronic being. The default ammunition for this weapon is blue photon or 20.25fc (photon calibur) but it can also accept clips in 25fc or red photon, which are much more unstable and can blow away just about anything as they explode."
     beltDescription="|p7Z-13"
     Mesh=LodMesh'DeusExItems.GlockPickup'
     CollisionRadius=7.000000
     CollisionHeight=1.000000
     invSlotsX=2    
}
